package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.custom.TareaOS3CustomDao;
import com.ejie.ab04b.dao.custom.TareaTramiteOS3CustomDao;
import com.ejie.ab04b.model.TareaOS3;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TareaOS3ServiceImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Service(value = "tareaOS3Service")
public class TareaOS3ServiceImpl implements TareaOS3Service {

	@Autowired()
	private TareaOS3CustomDao tareaOS3Dao;
	@Autowired()
	private TareaTramiteOS3CustomDao tareaTramiteOs3Dao;

	/**
	 * Inserts a single row in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @return the tarea OS 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TareaOS3 add(TareaOS3 tareaOS3) {
		return this.tareaOS3Dao.add(tareaOS3);
	}

	/**
	 * Updates a single row in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @return the tarea OS 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TareaOS3 update(TareaOS3 tareaOS3) {
		return this.tareaOS3Dao.update(tareaOS3);
	}

	/**
	 * Updates a single row in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @return the tarea OS 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TareaOS3 updateFilled(TareaOS3 tareaOS3) {
		return this.tareaOS3Dao.updateFilled(tareaOS3);
	}

	/**
	 * Finds a single row in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @return the tarea OS 3
	 */
	public TareaOS3 find(TareaOS3 tareaOS3) {
		return this.tareaOS3Dao.vfind(tareaOS3);
	}

	/**
	 * Finds a single row in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @return the tarea OS 3
	 */
	public TareaOS3 findTareaTramite(TareaOS3 tareaOS3) {
		return this.tareaTramiteOs3Dao.vfind(tareaOS3);
	}

	/**
	 * Finds a single row in the TareaOS3 table.
	 * 
	 *  mailboxTaskId
	 *            String
	 *  TareaOS3
	 *
	 * @param mailboxTaskId the mailbox task id
	 * @return the tarea OS 3
	 */
	public TareaOS3 findByMailboxTaskId(String mailboxTaskId) {
		return this.tareaOS3Dao.findByMailboxTaskId(mailboxTaskId);
	}

	/**
	 * Deletes a single row in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *
	 * @param tareaOS3 the tarea OS 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TareaOS3 tareaOS3) {
		this.tareaOS3Dao.remove(tareaOS3);
	}

	/**
	 * Finds a list of rows in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TareaOS3>
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TareaOS3> findAll(TareaOS3 tareaOS3,
			JQGridRequestDto jqGridRequestDto) {
		return (List<TareaOS3>) this.tareaOS3Dao.vfindAll(tareaOS3,
				jqGridRequestDto);
	}

	/**
	 * Finds a list of rows in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TareaOS3>
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TareaOS3> findAllTareatramite(TareaOS3 tareaOS3,
			JQGridRequestDto jqGridRequestDto) {
		return (List<TareaOS3>) this.tareaTramiteOs3Dao.vfindAll(tareaOS3,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the TareaOS3 table using like.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TareaOS3>
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TareaOS3> findAllLike(TareaOS3 tareaOS3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<TareaOS3>) this.tareaOS3Dao.findAllLike(tareaOS3,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the TareaOS3 table.
	 * 
	 *  filterTareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<TareaOS3>
	 *
	 * @param filterTareaOS3 the filter tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<TareaOS3> filter(TareaOS3 filterTareaOS3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<TareaOS3> listaTareaOS3 = this.tareaOS3Dao
				.findAllLike(filterTareaOS3, jqGridRequestDto, false);
		Long recordNum = this.tareaOS3Dao.findAllLikeCount(
				filterTareaOS3 != null ? filterTareaOS3 : new TareaOS3(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TareaOS3>> reorderSelection = this.tareaOS3Dao
					.reorderSelection(filterTareaOS3, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<TareaOS3>(jqGridRequestDto, recordNum,
					listaTareaOS3, reorderSelection);
		}
		return new JQGridResponseDto<TareaOS3>(jqGridRequestDto, recordNum,
				listaTareaOS3);
	}

	/**
	 * Searches rows in the TareaOS3 table.
	 * 
	 *  filterTareaOS3
	 *            TareaOS3
	 *  searchTareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TareaOS3>>
	 *
	 * @param filterTareaOS3 the filter tarea OS 3
	 * @param searchTareaOS3 the search tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<TareaOS3>> search(TareaOS3 filterTareaOS3,
			TareaOS3 searchTareaOS3, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.tareaOS3Dao.search(filterTareaOS3, searchTareaOS3,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in TareaOS3 table.
	 * 
	 *  filterTareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterTareaOS3 the filter tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(TareaOS3 filterTareaOS3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tareaOS3Dao.reorderSelection(filterTareaOS3,
				jqGridRequestDto, startsWith);
	}

}
